<?php
/**
 * Plugin Name: SQLite Object Cache
 * Version: 1.5.6
 * Plugin URI: https://github.com/OllieJones/sqlite-object-cache
 * Description: A persistent object cache backend powered by SQLite3.
 * Author: Oliver Jones
 * Author URI: https://github.com/OllieJones/
 * Requires at least: 5.5
 * Requires PHP: 5.6
 * Tested up to: 6.8
 *
 * Text Domain: sqlite-object-cache
 * Domain Path: /languages/
 *
 * @package SQLiteObjectCache
 * @author Oliver Jones
 * @since 0.1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
  exit;
}

require_once 'includes/class-sqlite-object-cache.php';
/* wp-cli interface activation */
$is_cli = false;
if ( defined( 'WP_CLI' ) && WP_CLI ) {
  $is_cli = true;
  require_once( plugin_dir_path( __FILE__ ) . 'includes/cli.php' );
}

if ( is_admin()  || $is_cli) {
  require_once 'includes/class-sqlite-object-cache-settings.php';
  require_once 'includes/lib/class-sqlite-object-cache-admin-api.php';
  require_once 'includes/lib/class-sqlite-object-cache-statistics.php';
  require_once 'includes/lib/class-sqlite-backup-exclusion.php';
  require_once 'includes/lib/class-file.php';
}
/**
 * Returns the main instance of SQLite_Object_Cache to prevent the need to use globals.
 *
 * @return object SQLite_Object_Cache
 * @since  1.0.0
 */
function sqlite_object_cache() {
  $instance = new SQLite_Object_Cache( __FILE__, '1.5.6' );

  if ( is_admin() ) {
    $instance->settings = new SQLite_Object_Cache_Settings( $instance );
  }

  return $instance;
}

sqlite_object_cache();
