<?php

/**
 * Note : Code is released under the GNU LGPL
 *
 * Please do not change the header of this file
 *
 * This library is free software; you can redistribute it and/or modify it under the terms of the GNU
 * Lesser General Public License as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See the GNU Lesser General Public License for more details.
 */
/**
 * File:        ShipmentInfo.php
 * Project:     DHL API
 *
 * @author      Al-Fallouji Bashar
 * @version     0.1
 */
namespace DhlVendor\DHL\Datatype\AM;

use DhlVendor\DHL\Datatype\Base;
/**
 * ShipmentInfo Request model for DHL API
 */
class ShipmentInfo extends Base
{
    /**
     * Is this object a subobject
     * @var boolean
     */
    protected $_isSubobject = \true;
    /**
     * Parameters of the datatype
     * @var array
     */
    protected $_params = array('OriginServiceArea' => array('type' => 'OriginServiceArea', 'required' => \false, 'subobject' => \true), 'DestinationServiceArea' => array('type' => 'DestinationServiceArea', 'required' => \false, 'subobject' => \true), 'ShipperName' => array('type' => 'PersonName', 'required' => \false, 'subobject' => \false, 'comment' => 'Name', 'maxLength' => '35'), 'ShipperAccountNumber' => array('type' => 'AccountNumber', 'required' => \false, 'subobject' => \false, 'comment' => 'DHL Account Number', 'maxInclusive' => '9999999999', 'minInclusive' => '100000000'), 'ConsigneeName' => array('type' => 'PersonName', 'required' => \false, 'subobject' => \false, 'comment' => 'Name', 'maxLength' => '35'), 'ShipmentDate' => array('type' => 'dateTime', 'required' => \false, 'subobject' => \true), 'Pieces' => array('type' => '', 'required' => \false, 'subobject' => \true), 'Weight' => array('type' => 'string', 'required' => \false, 'subobject' => \false), 'WeightUnit' => array('type' => '', 'required' => \false, 'subobject' => \false), 'EstDlvyDate' => array('type' => 'dateTime', 'required' => \false, 'subobject' => \false), 'EstDlvyDateUTC' => array('type' => 'dateTime', 'required' => \false, 'subobject' => \false), 'GlobalProductCode' => array('type' => 'GlobalProductCode', 'required' => \false, 'subobject' => \false, 'comment' => '', 'minLength' => '1', 'maxLength' => '4'), 'ShipmentDesc' => array('type' => 'string', 'required' => \false, 'subobject' => \false), 'DlvyNotificationFlag' => array('type' => '', 'required' => \false, 'subobject' => \false), 'Shipper' => array('type' => 'Shipper', 'required' => \false, 'subobject' => \true), 'Consignee' => array('type' => 'Consignee', 'required' => \false, 'subobject' => \true));
}
